; First Person Camera Example
 
IncludeFile "X3D.pbi" 

hwnd.l=OpenWindow(1,50,50,640,480,#PB_Window_SystemMenu,"Xtreme3D")

If hwnd=0 Or InitSprite()=0 Or InitKeyboard()=0 Or InitMouse()=0 Or InitSound()=0
End
EndIf 

ws.l=OpenWindowedScreen(WindowID(1),0,0,1,1,0,0,0)

x3d_start_(0,0,640,480,hwnd,#FALSE);
x3d_sync_(#VSYNC)
x3d_lighting_(0)
x3d_setTexturePaths_("res")
x3d_BackgroundColor_($000000)

; ************************ object sorting ********************
back.l=x3d_createObject_(#DUMMY,#NULL,"") 
d3dobj.l=x3d_createObject_(#DUMMY,#NULL,"")
front.l=x3d_createObject_(#DUMMY,#NULL,"")

down.l=x3d_createObject_(#DUMMY,#NULL,"")
x3d_setAbsoluteObjectDirection_(down,0.0,-1.0,0.0)

; *************************** Camera **************************
radius.f=3.5
d.l=x3d_createObject_(#DUMMY,d3dobj,"")
x3d_setObjectPosition_(d,0.0,10.0,-50.0)
X3D_setFPSBSRadius_(d,radius)
cam.l=x3d_createObject_(#CAMERA,d,"") 
x3d_setCameraViewDepth_(cam,800.0)
x3d_translateObject_(cam,0.0,3.5,0.0)
x3d_SetCamera_(cam); activate camera
x3d_RotateObject_(cam,0.0,180.0,0.0)


; *************************** actor ***************************
actor.l=x3d_createObject_(#ACTOR, d3dobj, "res\penguin.md2")
x3d_createMaterial_("mpengu","res\tpenguin.jpg",#FALSE)
x3d_setMaterial_(actor, "mpengu")
x3d_setObjectScale_(actor,0.05,0.05,0.05)
x3d_setObjectPosition_(actor,0.0,0.0,-40.0)

; ************************** Level ****************************
 level.l=X3D_createObject_(#FREEFORM,d3dobj, "res\level.3ds")
 x3d_FPSAddMap_(level)

; ++++++++++++++++++++++++ water ++++++++++++++++++++++++++++++++
water.l=X3D_createObject_(#WATER,d3dobj,"")
 x3d_createMaterial_("mwater","res\water03.png",#FALSE)
 x3d_setTextureMappingMode_("mwater",#tmmSphere)
 x3d_setBlendingMode_("mwater",#bmModulate)
 x3d_setMaterial_(water,"mwater")
 x3d_setObjectScale_(water,36.0,2.0,54.0)
 x3d_setObjectPosition_(water,0.0,-2.5,0.0)
 x3d_setWaterResolution_(water,8)

;**************************** Fog *****************************
x3d_FogDistance_(10.0,600.0)
x3d_EnableFog_(#TRUE)

; ************************** crosshair ************************
x3d_createMaterial_("mcross","res\crosshair09.png",#TRUE)
cross.l=x3d_createObject_(#SPRITE,front,"mcross")
x3d_setObjectPosition_(cross,320.0,240.0,0.0)

jump.f=0
gravity.f=0

Repeat
 EventID.l = WindowEvent()
  ExamineKeyboard();

If KeyboardPushed(#PB_Key_Escape) ; If the user has pressed on the close button
   Quit = 1
 EndIf      
 
If KeyboardPushed(#PB_KEY_LEFT) 
    x3d_rotateObject_(d,0.0,3.0,0.0)
EndIf
If KeyboardPushed(#PB_KEY_RIGHT) 
    x3d_rotateObject_(d,0.0,-3.0,0.0)
EndIf
If KeyboardPushed(#PB_KEY_W) 
    x3d_moveObject_(d,0.8)
EndIf
If KeyboardPushed(#PB_KEY_S) 
    x3d_moveObject_(d,-0.8)
EndIf
If KeyboardPushed(#PB_KEY_A) 
    x3d_strafeObject_(d,-0.5)
EndIf
If KeyboardPushed(#PB_KEY_D) 
    x3d_strafeObject_(d,0.5)
EndIf

x3d_setPositionOfObject_(down,d)
  *vb.vectorb=x3d_OctreeRaycast_(down,level)
 dy.f=*vb\y
 *v.vector=x3d_absoluteObjectPosition_(d)
 ty.f=*v\y-8.1
  If ty>dy
  gravity+0.1
  Else:gravity=0.0
  EndIf
 
 If KeyboardPushed(#PB_KEY_SPACE) And ty<=dy
    jump.f=2.6
  EndIf

ExamineMouse()
Gosub mouselook 

x3d_liftObject_(d,-gravity+jump)
jump-0.1
If jump<0:jump=0:EndIf

fps=x3d_render_()
SetWindowTitle(1,"FPS: "+Str(fps))

  Until Quit = 1

x3d_end_(); close 3D scene 
End 

mouselook:
dx.f=-MouseDeltaX()/8
dy.f=-MouseDeltaY()/8
x3d_rotateObject_(d,0.0,dx,0.0);
pitch.f=PeekF(x3d_pitchAngle_(cam))+dy
If pitch<89 And pitch>-69:x3d_rotateObject_(cam,dy,0.0,0.0):EndIf
Return





; ExecutableFormat=Windows
; Executable=D:\temp\Xtreme3D\Purebasic\fire.exe
; CPU=1
; DisableDebugger
; EOF